import pandas as pd
import os


def datatable():
    experiment_result = pd.read_csv("/Users/riccardo/Desktop/Thesis/Test/train.csv")
    experiment_result['passed_visual_inspection'] = experiment_result['passed_visual_inspection'].fillna('no')
    df = pd.read_csv('/Users/riccardo/Desktop/Thesis/Test/experiment_01.csv')
    frames = []
    for i in range(1, 19):
        # load files
        exp_num = '0' + str(i) if i < 10 else str(i)
        frame = pd.read_csv(f"/Users/riccardo/Desktop/Thesis/Test/experiment_{exp_num}.csv")

        # load each experiment result row
        exp_result_row = experiment_result[experiment_result['No'] == i]
        frame['exp_num'] = i

        # add experiment settings to features
        frame['material'] = exp_result_row.iloc[0]['material']
        frame['feedrate'] = exp_result_row.iloc[0]['feedrate']
        frame['clamp_pressure'] = exp_result_row.iloc[0]['clamp_pressure']
        frame['machining_finalized'] = exp_result_row.iloc[0]['machining_finalized']
        frame['passed_visual_inspection'] = exp_result_row.iloc[0]['passed_visual_inspection']
        frame['tool_condition'] = exp_result_row.iloc[0]['tool_condition']

        frames.append(frame)
        df = pd.concat(frames, ignore_index=True)
    mapping_1 = {'Starting': 0,
                 'Prep': 1,
                 'Layer 1 Up': 2,
                 'Layer 1 Down': 3,
                 'Repositioning': 4,
                 'Layer 2 Up': 5,
                 'Layer 2 Down': 6,
                 'Layer 3 Up': 7,
                 'Layer 3 Down': 8,
                 'end': 9,
                 'End': 9}
    mapping_2 = {'worn': 0,
                 'unworn': 1}
    mapping_3 = {'no': 0,
                 'yes': 1}

    df['Machining_Process'].replace(mapping_1, inplace=True)
    df['tool_condition'].replace(mapping_2, inplace=True)
    df['passed_visual_inspection'].replace(mapping_3, inplace=True)
    df['machining_finalized'].replace(mapping_3, inplace=True)
    df = df.sample(frac=1)
    df.drop_duplicates()
    print(df)
    column_headers = list(df.columns.values)
    print("The Column Header :", column_headers)
    return df
